<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('about_us_page_our_mission_sections')) {
            return;
        }

        Schema::create('about_us_page_our_mission_sections', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->text('paragraph')->nullable();
            $table->string('image')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (! Schema::hasTable('about_us_page_our_mission_sections')) {
            return;
        }

        Schema::drop('about_us_page_our_mission_sections');
    }
};
